%
% Natural Science Review journal document class file
% v0.1 for LaTeX 2e
%
% Copyright (C) 2024 Natural Science Review
%
% This file may be distributed and/or modified under the
% conditions of the LaTeX Project Public License, either version 1.3c
% of this license or (at your option) any later version.
%
%%Identification

\def\@version{1.5} %% without subparagraph
\def\filedate{2024/10/30}
\def\docdate {2024/10/30}   % Today

\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{nsr}[\filedate\space v\@version\space LaTeX2e NSR document class from\space\docdate] \relax

\typeout{------------------------------------------------------------------------}
\typeout{LaTeX2e Class file for Natural Science Review publication for LaTeX2e users}
\typeout{ }
\typeout{Use the boxit option to draw a box on page showing the correct margins}
\typeout{ }
\typeout{Itemize, Enumerate and Description environments are compact versions}
\typeout{------------------------------------------------------------------------}
\typeout{ }

%%Preliminary definitions, needed by the options
\providecommand{\headlinecolor}{\normalcolor}   % define initial headline color

%% xcolor 2023/11/15 v3.01 LaTeX color extensions (UK)
%\RequirePackage{xcolor}                     % setup color see scheme at https://encycolorpedia.ru/1761ab
%\definecolor{slcolor}{HTML}{882B21}
%\definecolor{electric}{HTML}{4169e1}

%%This parts handles the options passed to the class.

\newif\ifpreprint
\newif\iflongauthorlist

\DeclareOption{authoryear}{\xdef\@biboptions{round,authoryear}}
\DeclareOption{number}{\xdef\@biboptions{numbers}}
\DeclareOption{numbers}{\xdef\@biboptions{numbers}}

\typeout{------------------------------------------------------------------------}    
\typeout{Latex Class Setting:}

\DeclareOption{boxit}{%
    \PassOptionsToPackage{showframe}{geometry}    
    \typeout{*SHOW margins frame}    
     }

\PassOptionsToClass{12pt}{article}

\DeclareOption{preprint}{\global\preprinttrue}
\DeclareOption{print}{\global\preprintfalse}

\DeclareOption{longauthorlist}{\global\longauthorlisttrue}
\DeclareOption{notlongauthorlist}{\global\longauthorlistfalse}

\typeout{------------------------------------------------------------------------}    

\ExecuteOptions{12pt,a4paper,preprint,longauthorlist}
\ProcessOptions

\DeclareOption{black}{\renewcommand{\headlinecolor}{\color{black}}}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions\relax
\LoadClass{article}
%% flushend 2021/10/04 v4.0
\RequirePackage[]{flushend} %% modified 2.5

%% The amsmath package provides various useful equation environments.
%% amsmath 2023/05/13 v2.17o AMS math features
\RequirePackage{amsmath}

%% The amssymb package provides various useful mathematical symbols.
%% amssymb 2013/01/14 v3.01 AMS font symbols
\RequirePackage{amssymb}

% multirow 2021/03/15 v2.8 Span multiple rows of a table
\RequirePackage{multirow}
% wrapfig 2003/01/31  v 3.6
\RequirePackage{wrapfig}
% array 2023/10/16 v2.5g Tabular extension package (FMi)
\RequirePackage{array}
% eurosym 1998/08/06 v1.1 European currency symbol ``Euro''
\RequirePackage{eurosym}
% colortbl 2024/02/20 v1.0g Color table columns (DPC)
\RequirePackage{colortbl}

%
% Page layout:
%
%% geometry 2020/01/02 v5.9 Page Geometry
\RequirePackage[%		
		columnsep  	= 5mm,
		left        = 20mm,
		bottom      = 56pt,
		paperwidth 	= 595bp,  %% paperwidth   597.23 pt = 595.0 bp  {597.22530 pt]
		textwidth  	= 170mm,
		paperheight = 792bp,  %% paperheight  794.97 pt ≅ 792.0 bp  [794.96208 pt]
		textheight  = 9.5in,
		nomarginpar,
		centering,
        headheight=10pt,
        headsep=20pt,
        footskip=30pt,
        footnotesep=15pt
        ]
		{geometry}


\RequirePackage[dvipsnames]{xcolor}
\definecolor{myblue}{RGB}{0, 82, 153}

%% url 2013/09/16  ver 3.4  Verb mode for urls, etc.
\RequirePackage{url}

%% graphicx 2021/09/16 v1.2d Enhanced LaTeX Graphics (DPC,SPQR)
%%% Images %%%
\RequirePackage{graphicx}
\graphicspath{{figures/}}

%%% Fonts %%%
%% fontenc 2021/04/29 v2.0v Standard LaTeX package
\RequirePackage[T1, T2A]{fontenc}
%% inputenc 2021/02/14 v1.3d Input encoding file
\RequirePackage[utf8]{inputenc}
%% babel 2024/02/07 v24.2 The Babel package
\RequirePackage[english]{babel}
%% indentfirst 2023/07/02 v1.03 Indent first paragraph (DPC)
\RequirePackage{indentfirst}
%% multicol 2023/03/30 v1.9f multicolumn formatting (FMi)
\RequirePackage{multicol}
%% View document dimensions, there is also a command in the tex
%% layout 2023-08-20 v1.2e Show layout parameters
\RequirePackage{layout}
%% lineno 2023/05/20 line numbers on paragraphs v5.3
\RequirePackage{lineno}

%% blindtext 2012/01/06 V2.0 blindtext-Package
\RequirePackage{blindtext}
%% booktabs 2020/01/12 v1.61803398 Publication quality tables
\RequirePackage{booktabs}
%% caption 2023/08/05 v3.6o Customizing captions (AR)
\RequirePackage[figureposition=bottom,tableposition=top,skip=10pt, font=small, labelsep=period, labelfont=bf]{caption}

%% authblk 2001/02/27 1.3 (PWD)
\RequirePackage[affil-sl]{authblk}
\renewcommand{\Affilfont}{\small\itshape}

%% hyperref 2024-01-20 v7.01h Hypertext links for LaTeX
\RequirePackage[unicode=true,
	bookmarksopen={true},
	pdffitwindow=true, 
	colorlinks=true, 
	linkcolor=blue, 
	citecolor=blue, 
	urlcolor=blue, 
	hyperfootnotes=false, 
	pdfstartview={FitH},
        hypertexnames=false,
	pdfpagemode= UseNone]{hyperref}

%% orcidlink 2023/12/30 v1.0.5 Linked ORCiD logo macro package
%\RequirePackage{orcidlink}

\IfFileExists{orcidlink.sty}{\RequirePackage{orcidlink}}{}
\ifx\orcidlink\undefined\def\orcidlink#1{}\PackageWarning{orcidlink}{Missing package orcidlink(.sty). Will ignore all orcidlink commands.}\fi

%%Body of the class, most of the declarations appear here.

%Lists

%% enumitem 2019/06/20 v3.9 Customized lists
\RequirePackage{enumitem}
\newenvironment{Enumerate}{\begin{enumerate}[nosep]}{\end{enumerate}}
\newenvironment{Itemize}{\begin{itemize}[nosep]}{\end{itemize}}
\newenvironment{Description}{\begin{description}[nosep]}{\end{description}}

%Floatparameter:
\renewcommand{\topfraction}{.95}
\renewcommand{\bottomfraction}{.95}
\renewcommand{\textfraction}{0.1}
\renewcommand{\floatpagefraction}{0.8}

%Bibtex
\@ifundefined{@biboptions}{\xdef\@biboptions{numbers,sort&compress}}{}
\InputIfFileExists{\jobname.spl}{}{}
%% natbib 2010/09/13 8.31b (PWD, AO)
\RequirePackage[\@biboptions]{natbib}

\newwrite\splwrite
\immediate\openout\splwrite=\jobname.spl
\def\biboptions#1{\def\next{#1}\immediate\write\splwrite{%
   \string\g@addto@macro\string\@biboptions{%
    ,\expandafter\strip@prefix\meaning\next}}}

 \global\let\bibfont=\small
 \global\bibsep=1pt

\@ifpackageloaded{amsrefs}%
  {}
  {%\let\bibsection\relax%
  \AtBeginDocument{\def\cites@b#1#2,#3{%
    \begingroup[%
        \toks@{\InnerCite{#2}#1}%
        \ifx\@empty#3\@xp\@gobble\fi
        \cites@c#3%
}}}

\def\@seccntDot{.}
\def\@seccntformat#1{\csname the#1\endcsname\@seccntDot\hskip 0.5em}

\setcounter{secnumdepth}{5}

\renewcommand\section{\@startsection {section}{1}{\z@}%
           {12\p@ \@plus 6\p@ \@minus 3\p@}%
           {12\p@ \@plus 6\p@ \@minus 3\p@}%
           {\normalsize\bfseries}}
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
           {10\p@ \@plus 6\p@ \@minus 3\p@}%
           {10\p@ \@plus 6\p@ \@minus 3\p@}%
           {\normalfont\normalsize\itshape}}
\renewcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
           {6\p@ \@plus 6\p@ \@minus 3\p@}%
           {6\p@ \@plus 6\p@ \@minus 3\p@}%
           {\normalfont\normalsize\itshape}}

\newlength{\titleblockheight}       
\setlength{\titleblockheight}{3.5cm}

\newlength\titleblockstartskip
\setlength\titleblockstartskip{100pt}

\newlength\titleblockmiddleskip
\setlength\titleblockmiddleskip{1em}

\newlength\titleblockendskip
\setlength\titleblockendskip{8pt}


\AtEndDocument{\label{lastpage}}

\def\volume#1{\gdef\@vol{#1}}
\def\artnum#1{\gdef\@artnum{#1}}
\def\firstpage#1{\gdef\@firstpage{#1}%
                  \setcounter{page}{#1}}
                  
\def\lastpage{\pageref*{lastpage}}

\def\runauth#1{\gdef\@runauth{#1}}

\def\@datesubmitted{}
\newcommand{\datesubmitted}[1]{\gdef\@datesubmitted{#1}} 
\def\@datereceived{}
\newcommand{\datereceived}[1]{\gdef\@datereceived{#1}} 
\def\@daterevised{}
\newcommand{\daterevised}[1]{\gdef\@daterevised{#1}} 
\def\@dateaccepted{}
\newcommand{\dateaccepted}[1]{\gdef\@dateaccepted{#1}} 
\def\@datepublished{}
\newcommand{\datepublished}[1]{\gdef\@datepublished{#1}} 
\def\@doinum{}
\newcommand{\doinum}[1]{\gdef\@doinum{#1}}
\def\@copyrightyear{}
\newcommand{\copyrightyear}[1]{\gdef\@copyrightyear{#1}}

%% fancyhdr 2022/11/09 v4.1 Extensive control of page headers and footers
\RequirePackage{fancyhdr}
\IfPackageAtLeastTF{fancyhdr}{2021/01/04}{}{%
\PackageWarning{fancyhdr}{Insufficient version of package fancyhdr(.sty). At least 2021/01/04 is required.}}

\iflongauthorlist
\fancypagestyle{firstpage}{%
    \ifpreprint
        \fancyhf{}
        \renewcommand*\headrulewidth{0pt}
        \fancyfoot[L]{\vspace{-2.0\baselineskip}\par
        \footnotesize{Preprint submitted to Natural Science Review}
        }
        \fancyfoot[R]{\vspace{-2.0\baselineskip}\par
        \footnotesize{\@datesubmitted}
        }    
    \else
        \fancyhf{}
        \renewcommand*\headrulewidth{0pt}
        \fancyfoot[L]{\vspace{-3.0\baselineskip}\par
        \scriptsize\href{https://doi.org/\@doinum}{\color{black}{\tt https://doi.org/\@doinum}}\par
        \vspace{3pt}
        \scriptsize{Received: \@datereceived;
            Revised: \@daterevised;
            Accepted: \@dateaccepted;
            Published: \@datepublished\par}
        \scriptsize{Copyright: {© }by the author(s), \@copyrightyear, under license to Joint Institute for Nuclear Research. This article is an open access article distributed under the terms and conditions of the Creative Commons Attribution-NonCommercial 4.0 International license (CC BY-NC License 4.0).}
        }
    \fi
        }
\else
    \fancypagestyle{plain}{%
    \ifpreprint
        \fancyhf{}
        \renewcommand*\headrulewidth{0pt}
        \fancyfoot[L]{\vspace{-2.0\baselineskip}\par
        \footnotesize{Preprint submitted to Natural Science Review}
        }
        \fancyfoot[R]{\vspace{-2.0\baselineskip}\par
        \footnotesize{\@datesubmitted}
        }    
    \else
        \fancyhf{}
        \renewcommand*\headrulewidth{0pt}
        \fancyfoot[L]{\vspace{-3.0\baselineskip}\par
        \scriptsize\href{https://doi.org/\@doinum}{\color{black}{\tt https://doi.org/\@doinum}}\par
        \vspace{3pt}
        \scriptsize{Received: \@datereceived;
            Revised: \@daterevised;
            Accepted: \@dateaccepted;
            Published: \@datepublished\par}
        \scriptsize{Copyright: {© }by the author(s), \@copyrightyear, under license to Joint Institute for Nuclear Research. This article is an open access article distributed under the terms and conditions of the Creative Commons Attribution-NonCommercial 4.0 International license (CC BY-NC License 4.0).}
        }
    \fi
        }
\fi

\iflongauthorlist
    \def\ps@plain{%
    \ifpreprint
        \def\@oddhead{\uline{\parbox{0.5\textwidth}{\itshape\footnotesize\@runauth}%
        \parbox{0.5\textwidth}{\raggedleft\itshape\footnotesize%
        {Preprint submitted to Natural Science Review}
         }}}
        \let\@evenhead\@oddhead
        \let\@evenfoot\@empty%
        \let\@evenfoot\@oddfoot
    \else
        \def\@oddhead{\uline{\parbox{0.5\textwidth}{\itshape\footnotesize\@runauth}%
        \parbox{0.5\textwidth}{\raggedleft\itshape\footnotesize%
        {Natural Science Review}~{\bfseries\@vol}~\@artnum~(\the\year)
         }}}%
        \let\@evenhead\@oddhead
        \let\@evenfoot\@empty%
        \let\@evenfoot\@oddfoot
    \fi
    }
\else
    \def\ps@headings{%
    \ifpreprint
        \def\@oddhead{\uline{\parbox{1.0\textwidth}{\itshape\footnotesize\@runauth}%
         }}
        \let\@evenhead\@oddhead
        \let\@evenfoot\@empty%
        \let\@evenfoot\@oddfoot
    \else
        \def\@oddhead{\uline{\parbox{0.5\textwidth}{\itshape\footnotesize\@runauth}%
        \parbox{0.5\textwidth}{\raggedleft\itshape\footnotesize%
        {Natural Science Review}~{\bfseries\@vol}~\@artnum~(\the\year)
         }}}%
        \let\@evenhead\@oddhead
        \let\@evenfoot\@empty%
        \let\@evenfoot\@oddfoot
    \fi
    }
\fi

\def\@maketitle{%
                \iflongauthorlist
                    \thispagestyle{firstpage}
                \fi
                \enlargethispage{-1.5\baselineskip}
                \ifpreprint
                \else
                    \vspace*{-30pt}
                    \noindent
                    \begin{minipage}[c]{0.28\textwidth}
                    \begin{flushleft}
                    \includegraphics{NSRlogo}
                    \end{flushleft}
                    \end{minipage}
                    \raisebox{0.1mm}{%
                    \begin{minipage}[c]{0.71\textwidth}
                    \begin{flushright}
                    {\footnotesize{\sc natural science review}~
{\bfseries\@vol}~\@artnum~(\the\year)}\par
                    \vspace{1pt}
                    {\color{myblue}\hrule height 1.5pt}
                    \vspace{2pt}
                    {\footnotesize\href{https://nsr.jinr.int}{\color{black}{\tt nsr.jinr.int}}}
                    \end{flushright}
                    \end{minipage}}
                \fi
                \vspace*{-50pt}
                \vskip \titleblockstartskip \raggedright    
                {\Large\bfseries\headlinecolor {\@title} \par}
                \vskip \titleblockmiddleskip               
                {\begin{tabular}[t]{@{}c@{}}\raggedright\normalsize\@author \end{tabular}\par}
                \vskip \titleblockendskip
                }

%% ulem 2019/11/18
\RequirePackage[normalem]{ulem}

\iflongauthorlist
\pagestyle{plain}
\else
\pagestyle{headings}
\fi

\renewenvironment{abstract}{%
    \hrule
        \vspace{0pt}
        \small \begin{flushleft}%
        \bfseries \abstractname \vspace{-.5em}\vspace{\z@}%
        \end{flushleft}
%    \fi 
\par
     }

\def\keyword{%
  \vspace{5pt}
  \small \parskip\z@
  \noindent\textit{Keywords: }
  \raggedright                         
  \ignorespaces}
\def\endkeyword{\vspace{10pt} \hrule \vspace{8pt} \par }

\def\@alph#1{%
  \ifcase#1\or a\or b\or c\or d\or e\or f\or g\or h\or i\or j\or k\or
  l\or m\or n\or o\or p\or q\or r\or s\or t\or u\or v\or w\or x\or
  y\or z%
  \or aa\or ab\or ac\or ad\or ae\or af\or ag\or ah\or ai\or aj\or
  ak\or al\or am\or an\or ao\or ap\or aq\or ar\or as\or at\or au\or
  av\or aw\or ax\or ay\or az%
  \or ba\or bb\or bc\or bd\or be\or bf\or bg\or bh\or bi\or bj\or
  bk\or bl\or bm\or bn\or bo\or bp\or bq\or br\or bs\or bt\or bu\or
  bv\or bw\or bx\or by\or bz%
  \or ca\or cb\or cc\or cd\or ce\or cf\or cg\or ch\or ci\or cj\or
  ck\or cl\or cm\or cn\or co\or cp\or cq\or cr\or cs\or ct\or cu\or
  cv\or cw\or cx\or cy\or cz%
  \or da\or db\or dc\or dd\or de\or df\or dg\or dh\or di\or dj\or
  dk\or dl\or dm\or dn\or do\or dp\or dq\or dr\or ds\or dt\or du\or
  dv\or dw\or dx\or dy\or dz%
  \or ea\or eb\or ec\or ed\or ee\or ef\or eg\or eh\or ei\or ej\or
  ek\or el\or em\or en\or eo\or ep\or eq\or er\or es\or et\or eu\or
  ev\or ew\or ex\or ey\or ez%
  \or fa\or fb\or fc\or fd\or fe\or ff\or fg\or fh\or fi\or fj\or
  fk\or fl\or fm\or fn\or fo\or fp\or fq\or fr\or fs\or ft\or fu\or
  fv\or fw\or fx\or fy\or fz%
  \or ga\or gb\or gc\or gd\or ge\or gf\or gg\or gh\or gi\or gj\or
  gk\or gl\or gm\or gn\or go\or gp\or gq\or gr\or gs\or gt\or gu\or
  gv\or gw\or gx\or gy\or gz%
  \else\@ctrerr\fi}

\def\appendixname{Appendix}
\renewcommand\appendix{\par
  \setcounter{section}{0}%
  \setcounter{subsection}{0}%
%  \setcounter{equation}{0}
  \@addtoreset{equation}{section}%
  \@addtoreset{figure}{section}%
  \@addtoreset{table}{section}%
  \gdef\thefigure{\@Alph\c@section.\arabic{figure}}%
  \gdef\thetable{\@Alph\c@section.\arabic{table}}%
  \gdef\thesection{\appendixname~\@Alph\c@section}%
  \@addtoreset{equation}{section}%
  \gdef\theequation{\@Alph\c@section.\arabic{equation}}%
  \addtocontents{toc}{\string\let\string\numberline\string\tmptocnumberline}{}{}
}

% \number line width calculation for appendix.
\newdimen\appnamewidth
\def\tmptocnumberline#1{%
   \setbox0=\hbox{\appendixname}
   \appnamewidth=\wd0
   \addtolength\appnamewidth{2.5pc}
   \hb@xt@\appnamewidth{#1\hfill}
}

%% tocloft 2017/08/31 v2.3i parameterised ToC, etc., typesetting
\RequirePackage{tocloft}

\renewcommand{\tocloftpagestyle}{\ps@headings}
\renewcommand{\cfttoctitlefont}{\small\bfseries}
\setlength\cftaftertoctitleskip{10pt}
\setlength{\cftbeforesecskip}{0pt}
\renewcommand{\cftsecfont}{\small} 
\renewcommand{\cftsecaftersnum}{.}
\renewcommand{\cftsecleader}{\cftdotfill{\cftdotsep}}
\renewcommand{\cftsecpagefont}{\small\mdseries}

\setlength{\cftbeforesubsecskip}{0pt}
\renewcommand{\cftsubsecfont}{\small} 
\renewcommand{\cftsubsecaftersnum}{.}
\renewcommand{\cftsubsecleader}{\cftdotfill{\cftdotsep}}
\renewcommand{\cftsubsecpagefont}{\small\mdseries}

\setlength{\cftbeforesubsubsecskip}{0pt}
\renewcommand{\cftsubsubsecfont}{\small} 
\renewcommand{\cftsubsubsecaftersnum}{.}
\renewcommand{\cftsubsubsecleader}{\cftdotfill{\cftdotsep}}
\renewcommand{\cftsubsubsecpagefont}{\small\mdseries}

%% For publishing
\setcounter{tocdepth}{5}

%table font small
\RequirePackage{etoolbox}
\AtBeginEnvironment{tabular}{\small}
